interface Calculator {
  id: string;
  title: string;
  description: string;
  category: string;
  icon: string;
  path: string;
  tags: string[];
}

export const calculators: Calculator[] = [
  {
    id: 'currency-converter',
    title: 'Currency Converter',
    description: 'Convert between different currencies with live exchange rates.',
    category: 'Currency',
    icon: '💰',
    path: '/calculators/currency-converter',
    tags: ['currency', 'exchange', 'money', 'forex'],
  },
  {
    id: 'loan-calculator',
    title: 'Loan Calculator',
    description: 'Calculate monthly payments, total interest, and amortization schedule for any loan.',
    category: 'Loans',
    icon: '🏦',
    path: '/calculators/loan-calculator',
    tags: ['loan', 'debt', 'payments', 'amortization'],
  },
  {
    id: 'mortgage-calculator',
    title: 'Home Loan Calculator',
    description: 'Calculate your monthly home loan repayments, including rates and levies.',
    category: 'Real Estate',
    icon: '🏠',
    path: '/calculators/mortgage-calculator',
    tags: ['home loan', 'bond', 'house payment', 'real estate', 'mortgage'],
  },
  {
    id: 'interest-calculator',
    title: 'Interest Calculator',
    description: 'Calculate simple or compound interest on savings or investments.',
    category: 'Investing',
    icon: '📈',
    path: '/calculators/interest-calculator',
    tags: ['interest', 'savings', 'investing', 'apy', 'apr'],
  },
  {
    id: 'vat-calculator',
    title: 'VAT Calculator',
    description: 'Calculate VAT (15% for South Africa) for any amount.',
    category: 'Tax',
    icon: '🧾',
    path: '/calculators/vat-calculator',
    tags: ['vat', 'tax', 'south africa', 'value added tax'],
  },
  {
    id: 'inflation-calculator',
    title: 'Inflation Calculator',
    description: 'See how inflation affects the purchasing power of your money over time.',
    category: 'Inflation',
    icon: '📉',
    path: '/calculators/inflation-calculator',
    tags: ['inflation', 'purchasing power', 'cpi', 'money value'],
  },
  {
    id: 'retirement-calculator',
    title: 'Retirement Calculator',
    description: 'Plan your retirement savings and see how much you need to save.',
    category: 'Retirement',
    icon: '👵',
    path: '/calculators/retirement-calculator',
    tags: ['retirement', 'savings', 'pension', 'retirement annuity', 'RA', 'provident fund'],
  },
  {
    id: 'salary-converter',
    title: 'Salary to Hourly',
    description: 'Convert between annual salary and hourly wage.',
    category: 'Income',
    icon: '💼',
    path: '/calculators/salary-converter',
    tags: ['salary', 'wage', 'hourly', 'income', 'pay'],
  },
  {
    id: 'loan-to-income',
    title: 'Loan to Income Ratio',
    description: 'Calculate your debt-to-income ratio for loan applications.',
    category: 'Loans',
    icon: '📊',
    path: '/calculators/loan-to-income',
    tags: ['debt', 'income', 'ratio', 'loan approval'],
  },
  {
    id: 'net-worth',
    title: 'Net Worth Calculator',
    description: 'Calculate your total net worth by adding assets and subtracting liabilities.',
    category: 'Wealth',
    icon: '💵',
    path: '/calculators/net-worth',
    tags: ['net worth', 'assets', 'liabilities', 'wealth'],
  },
  {
    id: 'credit-card-interest',
    title: 'Credit Card Interest',
    description: 'Calculate how much interest you\'ll pay on your credit card balance.',
    category: 'Credit',
    icon: '💳',
    path: '/calculators/credit-card-interest',
    tags: ['credit card', 'interest', 'debt', 'payments'],
  },
  {
    id: 'savings-goal',
    title: 'Savings Goal',
    description: 'Calculate how much you need to save regularly to reach your financial goals.',
    category: 'Savings',
    icon: '🎯',
    path: '/calculators/savings-goal',
    tags: ['savings', 'goals', 'financial planning', 'budgeting'],
  },
  {
    id: 'break-even',
    title: 'Break-Even Calculator',
    description: 'Calculate the break-even point for your business or product.',
    category: 'Business',
    icon: '📊',
    path: '/calculators/break-even',
    tags: ['break-even', 'business', 'profit', 'costs', 'revenue'],
  },
];

export const getCalculatorById = (id: string) => {
  return calculators.find(calc => calc.id === id);
};

export const getFeaturedCalculators = (count: number = 6) => {
  // Return a mix of different categories
  const featuredCategories = ['Currency', 'Loans', 'Investing', 'Tax', 'Retirement', 'Income'];
  const featured: Calculator[] = [];
  
  // Get one calculator from each featured category
  featuredCategories.forEach(category => {
    const calc = calculators.find(c => c.category === category && !featured.some(f => f.id === c.id));
    if (calc) {
      featured.push(calc);
    }
  });
  
  // If we don't have enough featured, fill with random calculators
  while (featured.length < count) {
    const randomCalc = calculators[Math.floor(Math.random() * calculators.length)];
    if (!featured.some(c => c.id === randomCalc.id)) {
      featured.push(randomCalc);
    }
  }
  
  return featured.slice(0, count);
};
