import Link from 'next/link';
import Image from 'next/image';
import { FaFacebook, FaTwitter, FaLinkedin, FaInstagram, FaYoutube, FaEnvelope } from 'react-icons/fa';
import PlukLogo from '@/images/PlukLogo.png';

export default function Footer() {
  const currentYear = new Date().getFullYear();
  
  return (
    <footer className="bg-blue-950 text-white py-16 border-t-4 border-cyan-500">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-12">
          {/* About Section */}
          <div>
            <div className="mb-6">
              <Image 
                src={PlukLogo} 
                alt="SA PLUK Logo" 
                width={150} 
                height={50}
                className="h-12 w-auto brightness-0 invert"
              />
            </div>
            <p className="text-gray-400 text-sm mb-6 leading-relaxed">
              Professional financial calculators designed for South African needs. Make confident decisions with instant results.
            </p>
          </div>
          
          {/* Quick Links */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Quick Links</h4>
            <ul className="space-y-2">
              <li><Link href="/" className="text-gray-300 hover:text-white text-sm">Home</Link></li>
              <li><Link href="/calculators" className="text-gray-300 hover:text-white text-sm">All Calculators</Link></li>
              <li><Link href="/about" className="text-gray-300 hover:text-white text-sm">About Us</Link></li>
              <li><Link href="/contact" className="text-gray-300 hover:text-white text-sm">Contact</Link></li>
            </ul>
          </div>
          
          {/* Calculators */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Popular Calculators</h4>
            <ul className="space-y-2">
              <li><Link href="/calculators/currency-converter" className="text-gray-300 hover:text-white text-sm">Currency Converter</Link></li>
              <li><Link href="/calculators/loan-calculator" className="text-gray-300 hover:text-white text-sm">Loan Calculator</Link></li>
              <li><Link href="/calculators/mortgage-calculator" className="text-gray-300 hover:text-white text-sm">Home Loan Calculator</Link></li>
              <li><Link href="/calculators/interest-calculator" className="text-gray-300 hover:text-white text-sm">Interest Calculator</Link></li>
            </ul>
          </div>
          
          {/* Legal */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Legal</h4>
            <ul className="space-y-2">
              <li><Link href="/privacy-policy" className="text-gray-300 hover:text-white text-sm">Privacy Policy</Link></li>
              <li><Link href="/terms-of-service" className="text-gray-300 hover:text-white text-sm">Terms of Service</Link></li>
              <li><Link href="/disclaimer" className="text-gray-300 hover:text-white text-sm">Disclaimer</Link></li>
              <li><Link href="/sitemap.xml" className="text-gray-300 hover:text-white text-sm">Sitemap</Link></li>
            </ul>
          </div>
        </div>
        
        {/* Social Media */}
        <div className="border-t border-gray-700 mt-8 pt-6">
          <div className="flex justify-center space-x-6 mb-6">
            <a href="https://facebook.com/sapluk" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white transition-colors" aria-label="Facebook">
              <FaFacebook className="w-6 h-6" />
            </a>
            <a href="https://twitter.com/sapluk" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white transition-colors" aria-label="Twitter">
              <FaTwitter className="w-6 h-6" />
            </a>
            <a href="https://linkedin.com/company/sapluk" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white transition-colors" aria-label="LinkedIn">
              <FaLinkedin className="w-6 h-6" />
            </a>
            <a href="https://instagram.com/sapluk" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white transition-colors" aria-label="Instagram">
              <FaInstagram className="w-6 h-6" />
            </a>
            <a href="https://youtube.com/@sapluk" target="_blank" rel="noopener noreferrer" className="text-gray-400 hover:text-white transition-colors" aria-label="YouTube">
              <FaYoutube className="w-6 h-6" />
            </a>
            <a href="mailto:info@sapluk.co.za" className="text-gray-400 hover:text-white transition-colors" aria-label="Email">
              <FaEnvelope className="w-6 h-6" />
            </a>
          </div>
        </div>

        {/* Copyright */}
        <div className="text-center text-gray-400 text-sm">
          <p>© {currentYear} SA PLUK. All rights reserved.</p>
          <p className="mt-2">
            <span className="text-xs">
              The information provided by our calculators is for educational purposes only and should not be considered financial advice.
            </span>
          </p>
        </div>
      </div>
    </footer>
  );
}
