'use client';

import { useEffect } from 'react';
import { usePathname } from 'next/navigation';

type AdBannerProps = {
  slot: string;
  format?: string;
  layout?: string;
  layoutKey?: string;
  fullWidthResponsive?: boolean;
};

export default function AdBanner({
  slot,
  format = 'auto',
  layout = '',
  layoutKey = '',
  fullWidthResponsive = true,
}: AdBannerProps) {
  const pathname = usePathname();

  useEffect(() => {
    try {
      // @ts-ignore
      (window.adsbygoogle = window.adsbygoogle || []).push({});
    } catch (err) {
      console.error('Failed to push ad to adsbygoogle', err);
    }
  }, [pathname]);

  // Don't show ads on development
  if (process.env.NODE_ENV === 'development') {
    return (
      <div className="bg-gray-200 text-center p-4 my-4 rounded border border-dashed border-gray-400">
        <p className="text-sm text-gray-600">Ad Slot: {slot}</p>
        <p className="text-xs text-gray-500">(Ads will be shown in production)</p>
      </div>
    );
  }

  return (
    <div className="my-4 text-center">
      <ins
        className="adsbygoogle"
        style={{ display: 'block' }}
        data-ad-client={`ca-pub-${process.env.NEXT_PUBLIC_GOOGLE_ADSENSE}`}
        data-ad-slot={slot}
        data-ad-format={format}
        data-ad-layout={layout}
        data-ad-layout-key={layoutKey}
        data-full-width-responsive={fullWidthResponsive.toString()}
      ></ins>
    </div>
  );
}

// Helper components for different ad sizes
export function LeaderboardAd() {
  return (
    <div className="w-full my-4">
      <AdBanner 
        slot="top-banner"
        format="auto"
        fullWidthResponsive={true}
      />
    </div>
  );
}

export function SidebarAd() {
  return (
    <div className="w-full my-4">
      <AdBanner 
        slot="sidebar-ad"
        format="auto"
        fullWidthResponsive={true}
      />
    </div>
  );
}

export function InContentAd() {
  return (
    <div className="w-full my-8 text-center">
      <AdBanner 
        slot="in-content"
        format="auto"
        fullWidthResponsive={true}
      />
    </div>
  );
}
