import React from 'react';

const StatsCards = () => {
  const stats = [
    {
      icon: '💯',
      value: '100%',
      label: 'Satisfaction Rate',
      subtext: 'From our users',
      gradient: 'from-blue-400 to-blue-600'
    },
    {
      icon: '🚀',
      value: '50K+',
      label: 'Calculations',
      subtext: 'Performed monthly',
      gradient: 'from-cyan-400 to-cyan-600'
    },
    {
      icon: '⭐',
      value: '4.9/5',
      label: 'User Rating',
      subtext: 'Average score',
      gradient: 'from-purple-400 to-purple-600'
    }
  ];

  return (
    <div className="w-full py-20 px-4 bg-gradient-to-b from-white to-gray-50">
      <div className="max-w-6xl mx-auto">
        {/* Container with shadow */}
        <div className="bg-white rounded-3xl shadow-2xl p-10 border border-gray-100">
          <div className="flex flex-col lg:flex-row items-center justify-around gap-12">
            {stats.map((stat, index) => (
              <div
                key={index}
                className="flex flex-col items-center text-center space-y-4 group"
              >
                {/* Icon with gradient background */}
                <div className={`w-24 h-24 rounded-3xl bg-gradient-to-br ${stat.gradient} flex items-center justify-center shadow-lg group-hover:scale-110 group-hover:rotate-3 transition-all duration-300`}>
                  <span className="text-5xl">{stat.icon}</span>
                </div>

                {/* Value */}
                <div className={`text-5xl md:text-6xl font-black bg-gradient-to-r ${stat.gradient} bg-clip-text text-transparent`}>
                  {stat.value}
                </div>

                {/* Label */}
                <div className="space-y-1">
                  <p className="text-xl font-bold text-gray-900">
                    {stat.label}
                  </p>
                  <p className="text-sm text-gray-500 font-medium">
                    {stat.subtext}
                  </p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default StatsCards;
