import React from 'react';

interface Feature {
  icon: string;
  title: string;
  description: string;
  bgColor: string;
  accentColor: string;
}

const FeatureCards = () => {
  const features: Feature[] = [
    {
      icon: '🔒',
      title: 'Secure & Private',
      description: 'Your data never leaves your browser. Complete privacy guaranteed.',
      bgColor: 'bg-blue-50',
      accentColor: 'border-blue-200'
    },
    {
      icon: '📱',
      title: 'Mobile Friendly',
      description: 'Works perfectly on all devices - desktop, tablet, and mobile.',
      bgColor: 'bg-cyan-50',
      accentColor: 'border-cyan-200'
    },
    {
      icon: '⚡',
      title: 'Lightning Fast',
      description: 'Instant calculations with real-time results as you type.',
      bgColor: 'bg-purple-50',
      accentColor: 'border-purple-200'
    },
    {
      icon: '🎯',
      title: 'Accurate Results',
      description: 'Powered by proven financial formulas and algorithms.',
      bgColor: 'bg-pink-50',
      accentColor: 'border-pink-200'
    }
  ];

  return (
    <div className="w-full py-16 px-4">
      <div className="max-w-7xl mx-auto">
        {/* Section Header */}
        <div className="text-center mb-12">
          <h2 className="text-4xl md:text-5xl font-black text-gray-900 mb-4">
            Why Choose SA PLUK?
          </h2>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto">
            Professional tools designed with you in mind
          </p>
        </div>

        {/* Cards Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {features.map((feature, index) => (
            <div
              key={index}
              className={`${feature.bgColor} rounded-2xl p-8 border-2 ${feature.accentColor} hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 group`}
            >
              {/* Icon */}
              <div className="text-6xl mb-6 group-hover:scale-110 transition-transform duration-300">
                {feature.icon}
              </div>

              {/* Title */}
              <h3 className="text-2xl font-bold text-gray-900 mb-3">
                {feature.title}
              </h3>

              {/* Description */}
              <p className="text-gray-600 leading-relaxed">
                {feature.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default FeatureCards;
