import React from 'react';

const BenefitsCards = () => {
  const benefits = [
    {
      icon: '🎓',
      title: 'Learn',
      stat: '100+',
      description: 'Financial guides & tutorials',
      color: 'blue'
    },
    {
      icon: '💰',
      title: 'Save',
      stat: 'R1000+',
      description: 'Average monthly savings',
      color: 'cyan'
    },
    {
      icon: '📈',
      title: 'Grow',
      stat: '25%',
      description: 'Better financial decisions',
      color: 'purple'
    },
    {
      icon: '🎯',
      title: 'Achieve',
      stat: '90%',
      description: 'Reach financial goals',
      color: 'pink'
    }
  ];

  const getColorClasses = (color: string) => {
    const colors = {
      blue: {
        bg: 'bg-blue-100',
        text: 'text-blue-600',
        border: 'border-blue-300',
        hover: 'hover:bg-blue-200'
      },
      cyan: {
        bg: 'bg-cyan-100',
        text: 'text-cyan-600',
        border: 'border-cyan-300',
        hover: 'hover:bg-cyan-200'
      },
      purple: {
        bg: 'bg-purple-100',
        text: 'text-purple-600',
        border: 'border-purple-300',
        hover: 'hover:bg-purple-200'
      },
      pink: {
        bg: 'bg-pink-100',
        text: 'text-pink-600',
        border: 'border-pink-300',
        hover: 'hover:bg-pink-200'
      }
    };
    return colors[color as keyof typeof colors];
  };

  return (
    <div className="w-full py-16 px-4">
      <div className="max-w-7xl mx-auto">
        {/* Main rounded container */}
        <div className="bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50 rounded-3xl shadow-2xl p-8 md:p-12">
          {/* Title */}
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-black text-gray-900 mb-3">
              Your Financial Journey Starts Here
            </h2>
            <p className="text-lg text-gray-600">
              Everything you need to make smarter money decisions
            </p>
          </div>

          {/* Cards Grid */}
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            {benefits.map((benefit, index) => {
              const colors = getColorClasses(benefit.color);
              return (
                <div
                  key={index}
                  className={`bg-white rounded-2xl p-6 border-2 ${colors.border} ${colors.hover} transition-all duration-300 hover:shadow-xl hover:-translate-y-1 group`}
                >
                  {/* Icon */}
                  <div className={`${colors.bg} w-16 h-16 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300`}>
                    <span className="text-3xl">{benefit.icon}</span>
                  </div>

                  {/* Title */}
                  <h3 className="text-xl font-bold text-gray-900 mb-2">
                    {benefit.title}
                  </h3>

                  {/* Stat */}
                  <div className={`text-4xl font-black ${colors.text} mb-3`}>
                    {benefit.stat}
                  </div>

                  {/* Description */}
                  <p className="text-sm text-gray-600 leading-relaxed">
                    {benefit.description}
                  </p>
                </div>
              );
            })}
          </div>
        </div>
      </div>
    </div>
  );
};

export default BenefitsCards;
