import { LeaderboardAd, InContentAd } from '@/components/ads/AdBanner';

export const metadata = {
  title: 'Terms of Service - SA PLUK',
  description: 'Read the Terms of Service for SA PLUK, including acceptable use, disclaimers, and limitations of liability.',
};

export default function TermsPage() {
  return (
    <div className="space-y-8">
      <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-12 rounded-lg shadow-lg">
        <div className="container mx-auto px-4">
          <h1 className="text-3xl md:text-4xl font-bold mb-2">Terms of Service</h1>
          <p className="text-white/90">Effective date: {new Date().getFullYear()}-01-01</p>
        </div>
      </div>

      <LeaderboardAd />

      <div className="container mx-auto px-4">
        <div className="bg-white rounded-xl shadow-md p-6 md:p-8 prose max-w-none">
          <h2>Acceptance of Terms</h2>
          <p>
            By accessing or using SA PLUK, you agree to be bound by these Terms of Service and our Privacy Policy. If you do not agree, do not use the site.
          </p>

          <h2>Use of the Site</h2>
          <ul>
            <li>You may use our calculators for personal or internal business purposes.</li>
            <li>You agree not to misuse the site, interfere with its operation, or attempt to access it using methods other than the provided interface.</li>
            <li>You will not reverse-engineer, copy, or redistribute substantial parts of the site without permission.</li>
          </ul>

          <h2>No Financial Advice</h2>
          <p>
            The site provides educational and informational content only and does not constitute financial, tax, legal, or investment advice. Consult a qualified professional for advice regarding your specific situation.
          </p>

          <h2>Disclaimer of Warranties</h2>
          <p>
            The site and all content are provided "as is" without warranties of any kind, express or implied. We do not warrant that the site will be error-free or uninterrupted.
          </p>

          <h2>Limitation of Liability</h2>
          <p>
            To the maximum extent permitted by law, we will not be liable for any indirect, incidental, special, consequential, or punitive damages arising from or related to your use of the site.
          </p>

          <h2>Third-Party Links and Services</h2>
          <p>
            The site may contain links to third-party websites or services. We are not responsible for their content, policies, or practices.
          </p>

          <h2>Changes to Terms</h2>
          <p>
            We may modify these Terms at any time. Updates will be posted on this page. Your continued use of the site constitutes acceptance of the updated Terms.
          </p>

          <h2>Contact</h2>
          <p>
            For questions about these Terms, contact us at {' '}<a href="mailto:legal@financetools.pro">legal@financetools.pro</a>.
          </p>
        </div>
      </div>

      <InContentAd />
    </div>
  );
}
