import Link from 'next/link';
import { getFeaturedCalculators } from '@/data/calculators';
import InfoCards from '@/components/InfoCards';
import FeatureCards from '@/components/FeatureCards';
import StatsCards from '@/components/StatsCards';
import BenefitsCards from '@/components/BenefitsCards';

export const metadata = {
  title: 'SA PLUK - Free Online Financial Calculators for South Africa',
  description: 'Free online financial calculators for South African users. Calculate loans, mortgages, VAT, currency conversion, and more. Make informed financial decisions.',
  keywords: 'SA PLUK, south africa finance, loan calculator, mortgage calculator, currency converter, VAT calculator, financial planning',
};

export default function Home() {
  const featuredCalculators = getFeaturedCalculators(6);

  return (
    <div className="space-y-0">
      {/* Hero Section - Modern Tech Design */}
      <section className="relative bg-gradient-to-br from-gray-50 via-blue-50 to-purple-50 py-20 md:py-32 overflow-hidden">
        {/* Decorative Circuit Patterns */}
        <div className="absolute top-0 right-0 w-96 h-96 opacity-20">
          <svg viewBox="0 0 200 200" className="w-full h-full text-blue-600">
            <path d="M20 20 L60 20 M60 20 L60 60 M60 60 L100 60 M100 60 L100 20 M100 20 L140 20" stroke="currentColor" strokeWidth="2" fill="none"/>
            <path d="M20 80 L60 80 M60 80 L60 120 M60 120 L100 120" stroke="currentColor" strokeWidth="2" fill="none"/>
            <circle cx="20" cy="20" r="4" fill="currentColor"/>
            <circle cx="60" cy="20" r="4" fill="currentColor"/>
            <circle cx="60" cy="60" r="4" fill="currentColor"/>
            <circle cx="100" cy="60" r="4" fill="currentColor"/>
            <circle cx="100" cy="20" r="4" fill="currentColor"/>
            <circle cx="140" cy="20" r="4" fill="currentColor"/>
          </svg>
        </div>
        
        <div className="absolute bottom-0 left-0 w-80 h-80 opacity-20">
          <svg viewBox="0 0 200 200" className="w-full h-full text-cyan-500">
            <path d="M180 180 L140 180 M140 180 L140 140 M140 140 L100 140 M100 140 L100 180 M100 180 L60 180" stroke="currentColor" strokeWidth="2" fill="none"/>
            <path d="M180 120 L140 120 M140 120 L140 80 M140 80 L100 80" stroke="currentColor" strokeWidth="2" fill="none"/>
            <circle cx="180" cy="180" r="4" fill="currentColor"/>
            <circle cx="140" cy="180" r="4" fill="currentColor"/>
            <circle cx="140" cy="140" r="4" fill="currentColor"/>
            <circle cx="100" cy="140" r="4" fill="currentColor"/>
          </svg>
        </div>

        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-6xl mx-auto">
            {/* Badge */}
            <div className="flex justify-center mb-8">
              <div className="inline-flex items-center gap-3 px-6 py-3 bg-blue-600 text-white rounded-full shadow-lg">
                <svg className="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                  <path d="M10 3.5a1.5 1.5 0 013 0V4a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-.5a1.5 1.5 0 000 3h.5a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-.5a1.5 1.5 0 00-3 0v.5a1 1 0 01-1 1H6a1 1 0 01-1-1v-3a1 1 0 00-1-1h-.5a1.5 1.5 0 010-3H4a1 1 0 001-1V6a1 1 0 011-1h3a1 1 0 001-1v-.5z"/>
                </svg>
                <span className="font-bold text-sm tracking-wide">SA PLUK</span>
              </div>
            </div>

            {/* Main Heading with Icon */}
            <div className="text-center mb-12">
              <div className="flex justify-center items-center gap-6 mb-8">
                {/* Brain/Circuit Icon */}
                <div className="relative">
                  <svg className="w-32 h-32 md:w-40 md:h-40 text-blue-600" viewBox="0 0 200 200" fill="none">
                    {/* Brain outline */}
                    <path d="M100 40 C70 40 50 60 50 80 C50 85 51 90 53 95 L53 120 C53 140 70 160 100 160 C130 160 147 140 147 120 L147 95 C149 90 150 85 150 80 C150 60 130 40 100 40 Z" stroke="currentColor" strokeWidth="3" fill="none"/>
                    {/* Circuit lines inside brain */}
                    <path d="M70 70 L90 70 M90 70 L90 90 M90 90 L110 90" stroke="currentColor" strokeWidth="2"/>
                    <path d="M110 110 L130 110 M110 130 L130 130" stroke="currentColor" strokeWidth="2"/>
                    <circle cx="70" cy="70" r="3" fill="currentColor"/>
                    <circle cx="90" cy="70" r="3" fill="currentColor"/>
                    <circle cx="90" cy="90" r="3" fill="currentColor"/>
                    <circle cx="110" cy="90" r="3" fill="currentColor"/>
                    <circle cx="110" cy="110" r="3" fill="currentColor"/>
                    <circle cx="130" cy="110" r="3" fill="currentColor"/>
                  </svg>
                  {/* Circuit lines extending from brain */}
                  <div className="absolute -right-12 top-1/2 transform -translate-y-1/2">
                    <svg className="w-24 h-24 text-cyan-500" viewBox="0 0 100 100">
                      <path d="M0 50 L30 50 M30 50 L30 30 M30 30 L60 30 M30 50 L30 70 M30 70 L60 70" stroke="currentColor" strokeWidth="2" fill="none"/>
                      <circle cx="30" cy="50" r="3" fill="currentColor"/>
                      <circle cx="30" cy="30" r="3" fill="currentColor"/>
                      <circle cx="60" cy="30" r="3" fill="currentColor"/>
                      <circle cx="30" cy="70" r="3" fill="currentColor"/>
                      <circle cx="60" cy="70" r="3" fill="currentColor"/>
                    </svg>
                  </div>
                </div>
              </div>

              <h1 className="text-4xl md:text-6xl lg:text-7xl font-black mb-8 leading-tight">
                <span className="text-gray-800 block mb-2">SA PLUK</span>
                <span className="bg-gradient-to-r from-blue-600 via-blue-700 to-blue-800 bg-clip-text text-transparent block">
                  FINANCIAL
                </span>
                <span className="bg-gradient-to-r from-cyan-500 via-blue-500 to-purple-600 bg-clip-text text-transparent block">
                  CALCULATORS
                </span>
              </h1>

              <p className="text-lg md:text-xl text-gray-700 font-semibold max-w-3xl mx-auto mb-12 tracking-wide">
                EXPLORING FINANCIAL CLARITY WITH INTELLIGENT TOOLS
              </p>

              {/* CTA Buttons */}
              <div className="flex flex-wrap justify-center gap-6 mb-16">
                <Link 
                  href="/calculators" 
                  className="group bg-blue-600 hover:bg-blue-700 text-white font-bold py-5 px-12 rounded-full transition-all duration-300 transform hover:scale-105 shadow-xl hover:shadow-2xl flex items-center gap-3"
                >
                  <span>Get Started</span>
                  <svg className="w-5 h-5 group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                  </svg>
                </Link>
                
                <Link 
                  href="#featured-calculators" 
                  className="bg-white border-2 border-blue-600 text-blue-600 hover:bg-blue-50 font-bold py-5 px-12 rounded-full transition-all duration-300 shadow-lg"
                >
                  Explore Tools
                </Link>
              </div>

            </div>
          </div>
        </div>

      </section>

      {/* Info Cards Section */}
      <InfoCards />


      {/* Featured Calculators */}
      <section id="featured-calculators" className="py-24 bg-gradient-to-b from-white to-gray-50 border-b-4 border-cyan-500">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16 animate-fadeInUp">
            <div className="inline-block mb-6">
              <span className="text-sm font-bold tracking-widest text-cyan-600 uppercase bg-cyan-50 px-4 py-2 rounded-full">Our Tools</span>
            </div>
            <h2 className="text-5xl md:text-6xl font-black text-blue-950 mb-6 tracking-tight">
              Professional Calculators
            </h2>
            <div className="w-32 h-2 bg-gradient-to-r from-cyan-400 via-cyan-500 to-cyan-400 mx-auto mb-8 rounded-full"></div>
            <p className="text-gray-600 text-lg max-w-2xl mx-auto leading-relaxed">
              Precision tools designed for South African financial planning
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {featuredCalculators.map((calculator, index) => (
              <Link 
                key={calculator.id}
                href={calculator.path}
                className="group relative bg-white rounded-2xl border-2 border-gray-200 hover:border-cyan-500 transition-all duration-300 overflow-hidden shadow-lg hover:shadow-2xl hover:-translate-y-2"
                style={{ animationDelay: `${index * 100}ms` }}
              >
                {/* Top accent line */}
                <div className="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-cyan-400 via-cyan-500 to-cyan-400 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500"></div>
                
                <div className="p-8">
                  {/* Icon */}
                  <div className="relative mb-6">
                    <div className="w-24 h-24 bg-gradient-to-br from-gray-100 to-gray-200 rounded-2xl flex items-center justify-center group-hover:from-cyan-500 group-hover:to-cyan-400 transition-all duration-300 shadow-xl group-hover:rotate-3 group-hover:scale-110 border-2 border-gray-200 group-hover:border-cyan-400">
                      <span className="text-5xl transition-all duration-300">{calculator.icon}</span>
                    </div>
                  </div>
                  
                  {/* Content */}
                  <h3 className="text-2xl font-black mb-4 text-blue-950 group-hover:text-cyan-600 transition-colors tracking-tight">
                    {calculator.title}
                  </h3>
                  <p className="text-gray-600 mb-8 leading-relaxed text-base">
                    {calculator.description}
                  </p>
                  
                  {/* Footer */}
                  <div className="flex items-center justify-between pt-4 border-t-2 border-gray-200">
                    <span className="text-xs font-bold tracking-wider text-gray-500 uppercase">
                      {calculator.category}
                    </span>
                    <div className="flex items-center gap-2 text-blue-950 group-hover:text-cyan-600 group-hover:gap-4 transition-all font-semibold">
                      <span className="text-sm font-bold">Explore</span>
                      <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                      </svg>
                    </div>
                  </div>
                </div>
                
                {/* Corner decoration */}
                <div className="absolute bottom-0 right-0 w-16 h-16 bg-gradient-to-tl from-gray-100 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
              </Link>
            ))}
          </div>
          
          <div className="text-center mt-16">
            <Link 
              href="/calculators" 
              className="inline-flex items-center gap-3 bg-blue-950 hover:bg-cyan-500 hover:text-blue-950 text-white font-bold py-5 px-12 rounded-xl transition-all duration-300 shadow-xl hover:shadow-2xl hover:shadow-cyan-500/50 transform hover:scale-105 border-2 border-blue-950 hover:border-cyan-500"
            >
              <span>View All 13 Calculators</span>
              <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
              </svg>
            </Link>
          </div>
        </div>
      </section>

      {/* Feature Cards Section */}
      <FeatureCards />

      {/* Blog Preview Section */}
      <section className="py-24 bg-white border-b-4 border-cyan-500">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <span className="text-sm font-bold tracking-widest text-cyan-600 uppercase bg-cyan-50 px-4 py-2 rounded-full">Knowledge Hub</span>
            <h2 className="text-4xl md:text-5xl font-black text-blue-950 mb-2 mt-6">Latest Financial Insights</h2>
            <div className="w-32 h-2 bg-gradient-to-r from-cyan-400 via-cyan-500 to-cyan-400 mx-auto mt-6 mb-6 rounded-full"></div>
            <p className="text-gray-600 text-lg">Stay informed with our latest articles and tips</p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {[
              {
                title: '10 Ways to Save Money in South Africa',
                excerpt: 'Discover practical tips to reduce expenses and boost your savings in the current economic climate.',
                category: 'Savings',
                date: 'Dec 15, 2024',
                image: '💰',
              },
              {
                title: 'Understanding Your Credit Score',
                excerpt: 'Learn how credit scores work in SA and how to improve yours for better loan rates.',
                category: 'Credit',
                date: 'Dec 10, 2024',
                image: '📊',
              },
              {
                title: 'Tax-Free Savings Accounts Explained',
                excerpt: 'Maximize your TFSA benefits with our comprehensive guide to tax-free investing.',
                category: 'Investing',
                date: 'Dec 5, 2024',
                image: '🎯',
              },
            ].map((post, index) => (
              <div key={index} className="bg-white rounded-2xl shadow-lg overflow-hidden border-2 border-gray-200 hover:border-cyan-500 hover:shadow-2xl transition-all duration-300 group hover:-translate-y-2">
                <div className="bg-gradient-to-br from-gray-100 to-gray-200 p-16 text-center relative overflow-hidden">
                  <span className="text-7xl relative z-10 filter grayscale-0 transition-all duration-300">{post.image}</span>
                  <div className="absolute top-4 right-4 bg-cyan-500 text-white px-4 py-2 text-xs font-bold uppercase shadow-xl rounded-lg">{post.category}</div>
                </div>
                <div className="p-6">
                  <div className="flex items-center justify-between mb-3">
                    <span className="text-xs text-gray-500 font-semibold">{post.date}</span>
                  </div>
                  <h3 className="text-xl font-black text-blue-950 mb-3 group-hover:text-cyan-600 transition-colors leading-tight">{post.title}</h3>
                  <p className="text-gray-600 text-sm mb-4 leading-relaxed">{post.excerpt}</p>
                  <button className="text-blue-950 hover:text-cyan-600 font-bold text-sm flex items-center group-hover:gap-2 transition-all">
                    Read More 
                    <svg className="w-4 h-4 ml-1 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                    </svg>
                  </button>
                </div>
              </div>
            ))}
          </div>

          <div className="text-center mt-12">
            <Link href="/blog" className="inline-flex items-center gap-2 bg-blue-950 hover:bg-cyan-500 hover:text-blue-950 text-white font-bold py-4 px-10 rounded-xl transition-all duration-300 shadow-xl hover:shadow-2xl hover:shadow-cyan-500/50 transform hover:scale-105 border-2 border-blue-950 hover:border-cyan-500">
              View All Articles
              <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
              </svg>
            </Link>
          </div>
        </div>
      </section>

      {/* Stats Cards Section */}
      <StatsCards />

      {/* Benefits Cards Section */}
      <BenefitsCards />

      {/* SEO Content */}
      <section className="py-12 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <h2 className="text-3xl font-bold text-center mb-8">Make Smarter Financial Decisions</h2>
            <div className="prose max-w-none">
              <p className="text-lg text-gray-700 mb-6">
                Welcome to FinanceTools.pro, your trusted source for free online financial calculators. 
                Our comprehensive collection of calculators helps you plan your financial future with confidence.
              </p>
              
              <h3 className="text-xl font-semibold mt-8 mb-4">Why Use Our Financial Calculators?</h3>
              <ul className="list-disc pl-6 space-y-2 mb-6">
                <li><strong>Accurate Calculations:</strong> Get precise results for all your financial planning needs.</li>
                <li><strong>Easy to Use:</strong> Simple interfaces that make complex calculations straightforward.</li>
                <li><strong>Completely Free:</strong> No hidden fees or subscriptions - all our tools are 100% free to use.</li>
                <li><strong>Mobile-Friendly:</strong> Access our calculators on any device, anywhere, anytime.</li>
              </ul>
              
              <h3 className="text-xl font-semibold mt-8 mb-4">Popular Financial Calculations</h3>
              <p className="mb-4">
                Our calculators cover a wide range of financial topics, including:
              </p>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div className="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                  <h4 className="font-semibold text-blue-700 mb-2">Loan & Mortgage</h4>
                  <p className="text-sm text-gray-600">
                    Calculate monthly payments, interest costs, and amortization schedules for personal loans, auto loans, and mortgages.
                  </p>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                  <h4 className="font-semibold text-blue-700 mb-2">Savings & Investments</h4>
                  <p className="text-sm text-gray-600">
                    Plan your savings goals, calculate compound interest, and project investment growth over time.
                  </p>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                  <h4 className="font-semibold text-blue-700 mb-2">Currency & Inflation</h4>
                  <p className="text-sm text-gray-600">
                    Convert between currencies and see how inflation impacts the purchasing power of your money.
                  </p>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                  <h4 className="font-semibold text-blue-700 mb-2">Tax & Salary</h4>
                  <p className="text-sm text-gray-600">
                    Calculate VAT, convert between salary and hourly rates, and understand your take-home pay.
                  </p>
                </div>
              </div>
              
              <h3 className="text-xl font-semibold mt-8 mb-4">Start Planning Today</h3>
              <p>
                Whether you're buying a home, planning for retirement, or just trying to better understand your finances, 
                our free calculators provide the insights you need to make informed decisions. 
                Explore our tools today and take control of your financial future!
              </p>
            </div>
          </div>
        </div>
      </section>
      
      {/* Final CTA */}
      <section className="bg-gradient-to-br from-blue-950 via-blue-900 to-blue-800 text-white py-24 relative overflow-hidden">
        <div className="absolute inset-0 opacity-5">
          <div className="absolute inset-0" style={{
            backgroundImage: `url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M10 10h20M30 10h20M10 30h40M10 50h20M30 50h20M10 70h40M10 90h20M30 90h20' stroke='%2300bcd4' stroke-width='1' fill='none'/%3E%3Ccircle cx='10' cy='10' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='30' cy='10' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='50' cy='10' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='10' cy='30' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='50' cy='30' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='10' cy='50' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='30' cy='50' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='50' cy='50' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='10' cy='70' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='50' cy='70' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='10' cy='90' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='30' cy='90' r='2' fill='%2300bcd4'/%3E%3Ccircle cx='50' cy='90' r='2' fill='%2300bcd4'/%3E%3C/svg%3E")`,
          }}></div>
        </div>
        <div className="container mx-auto px-4 text-center relative z-10">
          <h2 className="text-4xl md:text-6xl font-black mb-8 leading-tight">Ready to Take Control of Your Finances?</h2>
          <p className="text-xl mb-10 max-w-2xl mx-auto text-cyan-200">
            Access all our free financial calculators and start making smarter money decisions today.
          </p>
          <Link 
            href="/calculators" 
            className="inline-flex items-center gap-3 bg-cyan-500 text-blue-950 hover:bg-cyan-400 font-bold py-6 px-14 text-lg rounded-xl transition-all duration-300 shadow-2xl hover:shadow-cyan-500/50 transform hover:scale-105 border-2 border-cyan-500"
          >
            Get Started Now
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
            </svg>
          </Link>
        </div>
      </section>
    </div>
  );
}
